/** @file   sample.cpp
 * @brief   Implementation of Sample - class.
 * @version $Revision: 1.1.1.1 $
 * @author  Tomi Lamminsaari
 */

#include "sample.h"
#include <allegro.h>

namespace eng2d {

///
/// Static members, constants and datatypes
/// =======================================




///
/// Constructors, destructor and operators
/// ======================================

/** Constructor.
 */
Sample::Sample() :
  m_pData( 0 )
{
}



/** Constructor
 */
Sample::Sample( SAMPLE* pS ) :
  m_pData( pS )
{
}




/** Destructor
 */
Sample::~Sample()
{
}




///
/// Public methods
/// ==============

/** Sets the sampledata
 */
void Sample::setData( SAMPLE* pS )
{
//  this->clear();
  m_pData = pS;
}





///
/// Getter methods
/// ==============


/** Returns the pointer to allegro-format sample data.
 */
SAMPLE* Sample::al_SAMPLE() const
{
  return m_pData;
}



/** Returns the number of bits the sample has.
 */
int Sample::bits() const
{
  if ( this->isValid() == true ) {
    return m_pData->bits;
  }
  return 0;
}



/** Tells if this is a stereosample
 */
bool Sample::stereo() const
{
  if ( this->isValid() == true ) {
    return static_cast<bool>( m_pData->stereo );
  }
  return false;
}



/** Returns the frequency
 */
int Sample::freq() const
{
  if ( this->isValid() == true ) {
    return m_pData->freq;
  }
  return 0;
}



/** Returns the length of this sample
 */
int Sample::len() const
{
  if ( this->isValid() == true ) {
    return m_pData->len;
  }
  return 0;
}



/** Tells if there is valid sampledata.
 */
bool Sample::isValid() const
{
  if ( m_pData == 0 ) {
    return false;
  }
  return true;
}



///
/// Private or Protected methods
/// ============================



} // end of namespace
